package ru.yandex.direct.grid.model.entity.campaign.strategy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyAvgCpaPerCamp;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyAvgCpaPerCampExtractor extends GdStrategyExtractor<GdCampaignStrategyAvgCpaPerCamp> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    public GdCampaignStrategyAvgCpaPerCamp extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup,
            StrategyData strategyData) {
        return new GdCampaignStrategyAvgCpaPerCamp()
                .withLastBidderRestartTime(Optional.ofNullable(strategyData)
                        .map(StrategyData::getLastBidderRestartTime)
                        .map(LocalDateTime::toLocalDate)
                        .orElse(null))
                .withAvgBid(ifNotNull(strategyData, StrategyData::getAvgBid))
                .withAvgCpa(ifNotNull(strategyData, StrategyData::getAvgCpa))
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withGoalId(ifNotNull(strategyData, StrategyData::getGoalId))
                .withPayForConversion(ifNotNull(strategyData, StrategyData::getPayForConversion));
    }

    @Override
    public Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpaPerCamp) gdCampaignFlatStrategy).getGoalId();
    }

    @Override
    protected LocalDate getLastBidderRestartTime(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpaPerCamp) gdCampaignFlatStrategy).getLastBidderRestartTime();
    }

    @Override
    @Nullable
    public Boolean isPayForConversionEnabled(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpaPerCamp) gdCampaignFlatStrategy).getPayForConversion();
    }

}
