package ru.yandex.direct.grid.model.entity.campaign.strategy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyAvgCpaPerFilter;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyAvgCpaPerFilterExtractor extends GdStrategyExtractor<GdCampaignStrategyAvgCpaPerFilter> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    public GdCampaignStrategyAvgCpaPerFilter extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup,
            StrategyData strategyData) {
        return new GdCampaignStrategyAvgCpaPerFilter()
                .withLastBidderRestartTime(Optional.ofNullable(strategyData)
                        .map(StrategyData::getLastBidderRestartTime)
                        .map(LocalDateTime::toLocalDate)
                        .orElse(null))  .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withFilterAvgCpa(ifNotNull(strategyData, StrategyData::getFilterAvgCpa))
                .withFilterAvgBid(ifNotNull(strategyData, StrategyData::getFilterAvgBid))
                .withGoalId(ifNotNull(strategyData, StrategyData::getGoalId))
                .withPayForConversion(ifNotNull(strategyData, StrategyData::getPayForConversion));
    }

    @Override
    protected LocalDate getLastBidderRestartTime(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpaPerFilter) gdCampaignFlatStrategy).getLastBidderRestartTime();
    }

    @Override
    protected Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpaPerFilter) gdCampaignFlatStrategy).getGoalId();
    }
}
