package ru.yandex.direct.grid.model.entity.campaign.strategy;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyAvgCpcPerCamp;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyAvgCpcPerCampExtractor extends GdStrategyExtractor<GdCampaignStrategyAvgCpcPerCamp> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    public GdCampaignStrategyAvgCpcPerCamp extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup,
            StrategyData strategyData) {
        return new GdCampaignStrategyAvgCpcPerCamp()
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withAvgBid(ifNotNull(strategyData, StrategyData::getAvgBid));
    }
}
