package ru.yandex.direct.grid.model.entity.campaign.strategy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyAvgCpi;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyAvgCpiExtractor extends GdStrategyExtractor<GdCampaignStrategyAvgCpi> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    public GdCampaignStrategyAvgCpi extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                                      StrategyData strategyData) {
        return new GdCampaignStrategyAvgCpi()
                .withLastBidderRestartTime(Optional.ofNullable(strategyData)
                        .map(StrategyData::getLastBidderRestartTime)
                        .map(LocalDateTime::toLocalDate)
                        .orElse(null))
                .withAvgCpi(ifNotNull(strategyData, StrategyData::getAvgCpi))
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withGoalId(ifNotNull(strategyData, StrategyData::getGoalId))
                .withPayForConversion(ifNotNull(strategyData, StrategyData::getPayForConversion));
    }

    @Override
    public Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpi) gdCampaignFlatStrategy).getGoalId();
    }

    @Override
    protected LocalDate getLastBidderRestartTime(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpi) gdCampaignFlatStrategy).getLastBidderRestartTime();
    }

    @Override
    @Nullable
    public Boolean isPayForConversionEnabled(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyAvgCpi) gdCampaignFlatStrategy).getPayForConversion();
    }
}
