package ru.yandex.direct.grid.model.entity.campaign.strategy;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyAvgCpv;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithCustomPeriod;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyAvgCpvCustomPeriodExtractor extends GdStrategyExtractor<GdCampaignStrategyAvgCpv> {

    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithCustomPeriod(strategyData);
    }

    @Override
    protected GdCampaignStrategyAvgCpv extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
            StrategyData strategyData) {
        return new GdCampaignStrategyAvgCpv()
                .withAvgCpv(ifNotNull(strategyData, StrategyData::getAvgCpv))
                .withPayForConversion(strategyData.getPayForConversion())
                .withDailyChangeCount(strategyData.getDailyChangeCount())
                .withLastChangeTime(strategyData.getLastUpdateTime());
    }

}
