package ru.yandex.direct.grid.model.entity.campaign.strategy;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyAvgCpm;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithDailyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyCpmDefaultExtractor extends GdStrategyExtractor<GdCampaignStrategyAvgCpm> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return false;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithDailyBudgetOnly(campaignStrategyGroup);
    }

    @Override
    public GdCampaignStrategyAvgCpm extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                                      StrategyData strategyData) {
        return new GdCampaignStrategyAvgCpm().withAvgCpm(ifNotNull(strategyData, StrategyData::getAvgCpm));
    }
}
