package ru.yandex.direct.grid.model.entity.campaign.strategy;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyAvgCpm;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithCustomPeriod;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyCpmMaxReachCustomPeriodExtractor extends GdStrategyExtractor<GdCampaignStrategyAvgCpm> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithCustomPeriod(strategyData);
    }

    @Override
    protected GdCampaignStrategyAvgCpm extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                                         StrategyData strategyData) {
        return new GdCampaignStrategyAvgCpm()
                .withAvgCpm(ifNotNull(strategyData, StrategyData::getAvgCpm))
                .withDailyChangeCount(strategyData.getDailyChangeCount())
                .withLastChangeTime(strategyData.getLastUpdateTime());
    }
}
