package ru.yandex.direct.grid.model.entity.campaign.strategy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;

import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyCrr;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyCrrExtractor extends GdStrategyExtractor<GdCampaignStrategyCrr> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup,
                                          @Nullable StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    protected GdCampaignStrategyCrr extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                                      @Nullable StrategyData strategyData) {
        return new GdCampaignStrategyCrr()
                .withLastBidderRestartTime(Optional.ofNullable(strategyData)
                        .map(StrategyData::getLastBidderRestartTime)
                        .map(LocalDateTime::toLocalDate)
                        .orElse(null))
                .withCrr(ifNotNull(strategyData, StrategyData::getCrr))
                .withGoalId(ifNotNull(strategyData, StrategyData::getGoalId))
                .withPayForConversion(ifNotNull(strategyData, StrategyData::getPayForConversion));
    }

    @Override
    protected Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyCrr) gdCampaignFlatStrategy).getGoalId();
    }

    @Override
    protected LocalDate getLastBidderRestartTime(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyCrr) gdCampaignFlatStrategy).getLastBidderRestartTime();
    }

    @Override
    @Nullable
    protected Boolean isPayForConversionEnabled(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyCrr) gdCampaignFlatStrategy).getPayForConversion();
    }
}
