package ru.yandex.direct.grid.model.entity.campaign.strategy;

import java.time.LocalDate;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyType;
import ru.yandex.direct.grid.model.campaign.strategy.GdStrategyType;

import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toGdCampaignPlatform;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public abstract class GdStrategyExtractor<T extends GdCampaignFlatStrategy> {
    /**
     * Метод определяющий к какому "старому" типу относится стратегия
     * Считаем устаревшим, но избавиться сможем только когда фронт полностью перейдет на новые типы
     * DIRECT-105615
     */
    @Deprecated
    public T extractFlatStrategy(GdiCampaignStrategyGroup campaignStrategyGroup,
                                 GdCampaignStrategyType strategyType) {
        StrategyData strategyData = extractStrategyData(campaignStrategyGroup);

        T gdCampaignStrategy = extractStrategyTypeSpecificFields(campaignStrategyGroup, strategyData);

        GdCampaignBudget gdCampaignBudget = calcBudget(campaignStrategyGroup, strategyData);
        gdCampaignStrategy.withType(strategyType)
                .withStrategyType(GdStrategyType.valueOf(strategyType.name()))
                .withPlatform(toGdCampaignPlatform(campaignStrategyGroup.getPlatform()))
                .withIsAutoBudget(isTypeAutoBudget())
                .withBudget(gdCampaignBudget);

        return gdCampaignStrategy;

    }

    /**
     * Метод определяющий к какому "новому" типу относится стратегия
     */
    public T extractStrategy(GdiCampaignStrategyGroup campaignStrategyGroup,
                             GdStrategyType strategyType) {
        StrategyData strategyData = extractStrategyData(campaignStrategyGroup);

        T gdCampaignStrategy = extractStrategyTypeSpecificFields(campaignStrategyGroup, strategyData);

        GdCampaignBudget gdCampaignBudget = calcBudget(campaignStrategyGroup, strategyData);
        gdCampaignStrategy.withStrategyType(strategyType)
                //TODO: это фейковый тип, при новой фильтрации мы не можем одназначно определить "старый тип"
                .withType(GdCampaignStrategyType.NO_PREMIUM)
                .withPlatform(toGdCampaignPlatform(campaignStrategyGroup.getPlatform()))
                .withIsAutoBudget(isTypeAutoBudget())
                .withBudget(gdCampaignBudget);

        return gdCampaignStrategy;
    }

    public static StrategyData extractStrategyData(GdiCampaignStrategyGroup campaignStrategyGroup){
        return ifNotNull(campaignStrategyGroup.getStrategyData(), CampaignMappings::strategyDataFromDb);
    }

    protected abstract boolean hasSeparateBiddingSupport();

    protected abstract boolean isTypeAutoBudget();

    protected abstract GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                   @Nullable StrategyData strategyData);

    protected abstract T extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup,
            @Nullable StrategyData strategyData);

    protected Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return null;
    }

    protected LocalDate getLastBidderRestartTime(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return null;
    }

    protected Boolean isPayForConversionEnabled(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return false;
    };
}
