package ru.yandex.direct.grid.model.entity.campaign.strategy;

import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignOptsStrategyName;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyManual;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithDailyBudgetOnly;

public class GdStrategyNoPremiumExtractor extends GdStrategyExtractor<GdCampaignStrategyManual> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return true;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return false;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithDailyBudgetOnly(campaignStrategyGroup);
    }

    @Override
    protected GdCampaignStrategyManual extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                                         StrategyData strategyData) {
        boolean separateBidding = campaignStrategyGroup.getPlatform() == CampaignsPlatform.BOTH
                && campaignStrategyGroup.getOptsStrategyName() == GdiCampaignOptsStrategyName.DIFFERENT_PLACES;

        return new GdCampaignStrategyManual().withSeparateBidding(separateBidding);
    }
}
