package ru.yandex.direct.grid.model.entity.campaign.strategy;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdStrategyOptimizeClicks;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyOptimizeClicksExtractor extends GdStrategyExtractor<GdStrategyOptimizeClicks> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup,
                                          @Nullable StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    protected GdStrategyOptimizeClicks extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                                         @Nullable StrategyData strategyData) {
        return new GdStrategyOptimizeClicks()
                .withAvgBid(ifNotNull(strategyData, StrategyData::getAvgBid))
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withClicksLimit(ifNotNull(strategyData, StrategyData::getLimitClicks));
    }
}
