package ru.yandex.direct.grid.model.entity.campaign.strategy;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdStrategyOptimizeConversions;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyOptimizeConversionsExtractor extends GdStrategyExtractor<GdStrategyOptimizeConversions> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup,
                                          @Nullable StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    protected GdStrategyOptimizeConversions extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup, @Nullable StrategyData strategyData) {
        return new GdStrategyOptimizeConversions()
                .withAvgCpa(ifNotNull(strategyData, StrategyData::getAvgCpa))
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withGoalId(ifNotNull(strategyData, StrategyData::getGoalId))
                .withPayForConversion(ifNotNull(strategyData, StrategyData::getPayForConversion));
    }

    @Override
    public  Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdStrategyOptimizeConversions)gdCampaignFlatStrategy).getGoalId();
    }

    @Override
    @Nullable
    public Boolean isPayForConversionEnabled(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdStrategyOptimizeConversions) gdCampaignFlatStrategy).getPayForConversion();
    };
}
