package ru.yandex.direct.grid.model.entity.campaign.strategy;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdStrategyOptimizeInstalls;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;

public class GdStrategyOptimizeInstallsExtractor extends GdStrategyExtractor<GdStrategyOptimizeInstalls> {
    private static final Long DEFAULT_CPI_GOAL_ID = 4L;

    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup,
                                          @Nullable StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    protected GdStrategyOptimizeInstalls extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup, @Nullable StrategyData strategyData) {
        return new GdStrategyOptimizeInstalls()
                .withAvgCpi(ifNotNull(strategyData, StrategyData::getAvgCpi))
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withGoalId(getGoalId(campaignStrategyGroup.getType(), strategyData))
                .withPayForConversion(ifNotNull(strategyData, StrategyData::getPayForConversion));
    }

    @Override
    public Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdStrategyOptimizeInstalls) gdCampaignFlatStrategy).getGoalId();
    }

    @Override
    @Nullable
    public Boolean isPayForConversionEnabled(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdStrategyOptimizeInstalls) gdCampaignFlatStrategy).getPayForConversion();
    }

    private Long getGoalId(CampaignType campaignType, @Nullable StrategyData strategyData){
        // Для РМП кампании если цель null то ставится цель 'Установки приложения'
        if(campaignType == CampaignType.MOBILE_CONTENT && strategyData != null){
            return nvl(strategyData.getGoalId(), DEFAULT_CPI_GOAL_ID);
        }
        return ifNotNull(strategyData, StrategyData::getGoalId);
    }
}
