package ru.yandex.direct.grid.model.entity.campaign.strategy;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyPeriodFixBid;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithCustomPeriod;

public class GdStrategyPeriodFixBidExtractor extends GdStrategyExtractor<GdCampaignStrategyPeriodFixBid> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return false;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithCustomPeriod(strategyData);
    }

    @Override
    protected GdCampaignStrategyPeriodFixBid extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup,
            StrategyData strategyData) {
        return new GdCampaignStrategyPeriodFixBid();
    }
}
