package ru.yandex.direct.grid.model.entity.campaign.strategy;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyRoi;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyRoiExtractor extends GdStrategyExtractor<GdCampaignStrategyRoi> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    public GdCampaignStrategyRoi extractStrategyTypeSpecificFields(GdiCampaignStrategyGroup campaignStrategyGroup,
                                                                   StrategyData strategyData) {
        return new GdCampaignStrategyRoi()
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withGoalId(ifNotNull(strategyData, StrategyData::getGoalId))
                .withRoiCoef(ifNotNull(strategyData, StrategyData::getRoiCoef))
                .withReserveReturn(ifNotNull(strategyData, StrategyData::getReserveReturn))
                .withProfitability(ifNotNull(strategyData, StrategyData::getProfitability));
    }

    @Override
    public Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyRoi) gdCampaignFlatStrategy).getGoalId();
    }
}
