package ru.yandex.direct.grid.model.entity.campaign.strategy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;

import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignBudget;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignStrategyWeekBudget;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.calcBudgetForStrategiesWithWeeklyBudgetOnly;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GdStrategyWeekBudgetExtractor extends GdStrategyExtractor<GdCampaignStrategyWeekBudget> {
    @Override
    protected boolean hasSeparateBiddingSupport() {
        return false;
    }

    @Override
    protected boolean isTypeAutoBudget() {
        return true;
    }

    @Override
    protected GdCampaignBudget calcBudget(GdiCampaignStrategyGroup campaignStrategyGroup, StrategyData strategyData) {
        return calcBudgetForStrategiesWithWeeklyBudgetOnly(strategyData);
    }

    @Override
    protected GdCampaignStrategyWeekBudget extractStrategyTypeSpecificFields(
            GdiCampaignStrategyGroup campaignStrategyGroup,
            StrategyData strategyData) {
        return new GdCampaignStrategyWeekBudget()
                .withLastBidderRestartTime(Optional.ofNullable(strategyData)
                        .map(StrategyData::getLastBidderRestartTime)
                        .map(LocalDateTime::toLocalDate)
                        .orElse(null))
                .withBid(ifNotNull(strategyData, StrategyData::getBid))
                .withGoalId(ifNotNull(strategyData, StrategyData::getGoalId));
    }

    @Override
    public Long getGoalId(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyWeekBudget) gdCampaignFlatStrategy).getGoalId();
    }

    @Override
    protected LocalDate getLastBidderRestartTime(GdCampaignFlatStrategy gdCampaignFlatStrategy) {
        return ((GdCampaignStrategyWeekBudget) gdCampaignFlatStrategy).getLastBidderRestartTime();
    }

}
