package ru.yandex.direct.grid.model.entity.recommendation;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.feature.FeatureName;

public enum GdiRecommendationType {
    dailyBudget(RecommendationType.dailyBudget),

    removePagesFromBlackList(RecommendationType.removePagesFromBlackList),

    sendLicensesBanks(RecommendationType.sendLicensesBanks),

    sendLicensesMedServices(RecommendationType.sendLicensesMedServices),

    sendLicensesPharmacy(RecommendationType.sendLicensesPharmacy),

    switchOnAutotargeting(RecommendationType.switchOnAutotargeting),

    addMorePicturesToAdgroup(RecommendationType.addMorePicturesToAdgroup),

    changeAdGroupForModeration(RecommendationType.changeAdGroupForModeration),

    changeBannerForModeration(RecommendationType.changeBannerForModeration),

    changeAdGroupWithLowStat(RecommendationType.changeAdGroupWithLowStat),

    removePagesFromBlackListOfACampaign(RecommendationType.removePagesFromBlackListOfACampaign),

    addTitleExtension(RecommendationType.addTitleExtension),

    addSiteLinks(RecommendationType.addSiteLinks),

    addAdditionItemCallouts(RecommendationType.addAdditionItemCallouts),

    addBannerDisplayHrefs(RecommendationType.addBannerDisplayHrefs),

    addImageToBanner(RecommendationType.addImageToBanner),

    addTurboWebSiteToBanner(RecommendationType.addTurboWebSiteToBanner),

    addBannerFormats(RecommendationType.addBannerFormats),

    uploadAppropriateCreatives(RecommendationType.uploadAppropriateCreatives),

    chooseAppropriatePlacementsForAdGroup(RecommendationType.chooseAppropriatePlacementsForAdGroup),

    chooseAppropriatePlacementsForBanner(RecommendationType.chooseAppropriatePlacementsForBanner),

    addBannerFormatsForPriceSalesCorrectness(RecommendationType.addBannerFormatsForPriceSalesCorrectness),

    addBannerFormatsForPriceSalesCorrectnessInParentCampaign(
            RecommendationType.addBannerFormatsForPriceSalesCorrectnessInParentCampaign),

    videoButton(RecommendationType.videoButton),

    weeklyBudget(RecommendationType.weeklyBudget),

    increaseStrategyWeeklyBudget(RecommendationType.increaseStrategyWeeklyBudget),

    increaseStrategyTargetCPA(RecommendationType.increaseStrategyTargetCPA),

    decreaseStrategyTargetROI(RecommendationType.decreaseStrategyTargetROI),

    autopayStopped(RecommendationType.autopayStopped),

    overdraftDebt(RecommendationType.overdraftDebt),

    mainInvoice(RecommendationType.mainInvoice);

    private static final Map<RecommendationType, GdiRecommendationType> TYPES_MAP = Arrays.stream(values())
            .collect(Collectors.toMap(GdiRecommendationType::getCoreType, e -> e));

    private final RecommendationType coreType;

    GdiRecommendationType(RecommendationType coreType) {
        this.coreType = coreType;
    }

    public RecommendationType getCoreType() {
        return coreType;
    }

    public Long getId() {
        return coreType.getId();
    }

    public FeatureName getFeature() {
        return coreType.getFeature();
    }

    public static GdiRecommendationType fromType(@Nullable RecommendationType type) {
        if (type == null) {
            return null;
        }
        GdiRecommendationType result = TYPES_MAP.get(type);
        if (result == null) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        return result;
    }

    public static GdiRecommendationType fromId(@Nullable Long id) {
        return fromType(RecommendationType.fromId(id));
    }
}
