package ru.yandex.direct.grid.model.findandreplace;

import java.util.Set;

public interface FindAndReplaceParams<T> {

    /**
     * Значение для поиска
     */
    String getSearchText();

    /**
     * Значение для замены
     */
    String getChangeText();

    /**
     * Как меняем значение
     */
    ChangeMode getChangeMode();

    /**
     * В каких полях ищем
     */
    Set<T> getFields();

    /**
     * Параметры поиска
     */
    SearchOptions getSearchOptions();
}
