package ru.yandex.direct.grid.model.findandreplace;

import com.google.common.base.Objects;

/**
 * Параметры поиска
 */
public class SearchOptions {
    private boolean matchCase;
    private boolean onlyWholeWords;

    public boolean isMatchCase() {
        return matchCase;
    }

    public SearchOptions withMatchCase(boolean matchCase) {
        this.matchCase = matchCase;
        return this;
    }

    public boolean isOnlyWholeWords() {
        return onlyWholeWords;
    }

    public SearchOptions withOnlyWholeWords(boolean onlyWholeWords) {
        this.onlyWholeWords = onlyWholeWords;
        return this;
    }

    public SearchOptions copy() {
        return new SearchOptions()
                .withMatchCase(matchCase)
                .withOnlyWholeWords(onlyWholeWords);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SearchOptions that = (SearchOptions) o;
        return matchCase == that.matchCase &&
                onlyWholeWords == that.onlyWholeWords;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(matchCase, onlyWholeWords);
    }
}
