package ru.yandex.direct.grid.model.mapper

import graphql.schema.GraphQLInputType
import graphql.schema.GraphQLList
import graphql.schema.GraphQLOutputType
import io.leangen.geantyref.GenericTypeReflector
import io.leangen.geantyref.GenericTypeReflector.updateAnnotations
import io.leangen.graphql.annotations.GraphQLNonNull
import io.leangen.graphql.generator.mapping.TypeMapper
import io.leangen.graphql.generator.mapping.TypeMappingEnvironment
import io.leangen.graphql.metadata.TypedElement
import io.leangen.graphql.util.ClassUtils
import java.lang.reflect.AnnotatedElement
import java.lang.reflect.AnnotatedType
import java.lang.reflect.Field
import java.lang.reflect.Method
import java.lang.reflect.Parameter

//копипаста с io.leangen.graphql.generator.mapping.common.ListMapper с заменой getElementType
open class ListMapperCustom(
    private val nonNullMapperCustom : NonNullMapperCustom = NonNullMapperCustom()
) : TypeMapper {
    override fun toGraphQLType(
        javaType: AnnotatedType,
        mappersToSkip: Set<Class<out TypeMapper>>,
        env: TypeMappingEnvironment
    ): GraphQLOutputType {
        return GraphQLList(env.operationMapper.toGraphQLType(getElementType(javaType, env.rootElement, env.typeStack), env))
    }

    override fun toGraphQLInputType(
        javaType: AnnotatedType,
        mappersToSkip: Set<Class<out TypeMapper>>,
        env: TypeMappingEnvironment
    ): GraphQLInputType {
        return GraphQLList(env.operationMapper.toGraphQLInputType(getElementType(javaType, env.rootElement, env.typeStack), env))
    }

    override fun supports(element: AnnotatedElement, type: AnnotatedType): Boolean {
        return ClassUtils.isSuperClass(Collection::class.java, type)
    }

    private fun getElementType(
        javaType: AnnotatedType,
        element: TypedElement,
        typeStack: List<AnnotatedType>
    ): AnnotatedType {
        val result = GenericTypeReflector.getTypeParameter(javaType, Collection::class.java.typeParameters[0])
        if (isDeclaredInKotlin(element, typeStack)) {
            val isInsideOptional = typeStack.size >= 2 && nonNullMapperCustom.isOptionalType(typeStack[typeStack.size - 2])
            //на все элементы котлиновских списков вешаем NonNull по дефолту
            //не вешаем, если Optional<Long>, OptionalDouble и т д
            //поскольку котлин не умеет нормально всё равно в type_use аннотации на проперти, имеем определённое право так делать
            return updateAnnotations(result, if (isInsideOptional) arrayOf(GraphQlNullable()) else arrayOf(GraphQLNonNull()))
        } else {
            return result
        }
    }

    private fun isDeclaredInKotlin(element: TypedElement, typeStack: List<AnnotatedType>): Boolean {
        return element.elements.any {
            it is Field && it.declaringClass.isAnnotationPresent(Metadata::class.java)
                ||
                it is Method && it.declaringClass.isAnnotationPresent(Metadata::class.java)
                ||
                it is Parameter && it.declaringExecutable.declaringClass.isAnnotationPresent(Metadata::class.java)
        }
    }
}
