package ru.yandex.direct.grid.model.strategy;

import java.util.Map;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

import ru.yandex.direct.core.entity.strategy.model.StrategyAttributionModel;

public class GdStrategyAttributionModelConverter {
    private static final BiMap<StrategyAttributionModel, GdStrategyAttributionModel> fromSourceMap =
            ImmutableBiMap
                    .<StrategyAttributionModel, GdStrategyAttributionModel>builder()
                    .put(StrategyAttributionModel.LAST_CLICK, GdStrategyAttributionModel.LAST_CLICK)
                    .put(StrategyAttributionModel.FIRST_CLICK, GdStrategyAttributionModel.FIRST_CLICK)
                    .put(StrategyAttributionModel.LAST_SIGNIFICANT_CLICK,
                            GdStrategyAttributionModel.LAST_SIGNIFICANT_CLICK)
                    .put(StrategyAttributionModel.LAST_YANDEX_DIRECT_CLICK,
                            GdStrategyAttributionModel.LAST_YANDEX_DIRECT_CLICK)
                    .put(StrategyAttributionModel.FIRST_CLICK_CROSS_DEVICE,
                            GdStrategyAttributionModel.FIRST_CLICK_CROSS_DEVICE)
                    .put(StrategyAttributionModel.LAST_SIGNIFICANT_CLICK_CROSS_DEVICE,
                            GdStrategyAttributionModel.LAST_SIGNIFICANT_CLICK_CROSS_DEVICE)
                    .put(StrategyAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE,
                            GdStrategyAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE)
                    .put(StrategyAttributionModel.UNKNOWN, GdStrategyAttributionModel.UNKNOWN)
                    .build();
    private static final BiMap<GdStrategyAttributionModel, StrategyAttributionModel> toSourceMap =
            fromSourceMap.inverse();

    public static GdStrategyAttributionModel fromSource(StrategyAttributionModel value) {
        return getFromMap(fromSourceMap, value);
    }

    public static StrategyAttributionModel toSource(GdStrategyAttributionModel value) {
        return getFromMap(toSourceMap, value);
    }

    private static <K, V> V getFromMap(Map<K, V> map, K key) {
        if (key == null || map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalStateException("No such value: " + key);
    }
}
