package ru.yandex.direct.grid.model.strategy;

import java.util.Map;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode;

public class GdStrategyDayBudgetShowModeConverter {
    private static final BiMap<StrategyDayBudgetShowMode, GdStrategyDayBudgetShowMode> fromSourceMap =
            ImmutableBiMap
                    .<StrategyDayBudgetShowMode, GdStrategyDayBudgetShowMode>builder()
                    .put(StrategyDayBudgetShowMode.DEFAULT_, GdStrategyDayBudgetShowMode.DEFAULT_)
                    .put(StrategyDayBudgetShowMode.STRETCHED, GdStrategyDayBudgetShowMode.STRETCHED)
                    .build();
    private static final BiMap<GdStrategyDayBudgetShowMode, StrategyDayBudgetShowMode> toSourceMap =
            fromSourceMap.inverse();

    public static GdStrategyDayBudgetShowMode fromSource(StrategyDayBudgetShowMode value) {
        return getFromMap(fromSourceMap, value);
    }

    public static StrategyDayBudgetShowMode toSource(GdStrategyDayBudgetShowMode value) {
        return getFromMap(toSourceMap, value);
    }

    private static <K, V> V getFromMap(Map<K, V> map, K key) {
        if (key == null || map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalStateException("No such value: " + key);
    }
}
