package ru.yandex.direct.grid.model.strategy;

import java.util.Map;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

import ru.yandex.direct.core.entity.strategy.model.StrategyName;

public class GdStrategyNameConverter {
    private static final BiMap<StrategyName, GdStrategyName> fromSourceMap =
            ImmutableBiMap
                    .<StrategyName, GdStrategyName>builder()
                    .put(StrategyName.DEFAULT_, GdStrategyName.DEFAULT_)
                    .put(StrategyName.MIN_PRICE, GdStrategyName.MIN_PRICE)
                    .put(StrategyName.NO_PREMIUM, GdStrategyName.NO_PREMIUM)
                    .put(StrategyName.AUTOBUDGET, GdStrategyName.AUTOBUDGET)
                    .put(StrategyName.AUTOBUDGET_MEDIA, GdStrategyName.AUTOBUDGET_MEDIA)
                    .put(StrategyName.AUTOBUDGET_WEEK_BUNDLE, GdStrategyName.AUTOBUDGET_WEEK_BUNDLE)
                    .put(StrategyName.AUTOBUDGET_AVG_CLICK, GdStrategyName.AUTOBUDGET_AVG_CLICK)
                    .put(StrategyName.AUTOBUDGET_AVG_CPA, GdStrategyName.AUTOBUDGET_AVG_CPA)
                    .put(StrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP, GdStrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP)
                    .put(StrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER, GdStrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER)
                    .put(StrategyName.AUTOBUDGET_AVG_CPC_PER_CAMP, GdStrategyName.AUTOBUDGET_AVG_CPC_PER_CAMP)
                    .put(StrategyName.AUTOBUDGET_AVG_CPC_PER_FILTER, GdStrategyName.AUTOBUDGET_AVG_CPC_PER_FILTER)
                    .put(StrategyName.AUTOBUDGET_AVG_CPI, GdStrategyName.AUTOBUDGET_AVG_CPI)
                    .put(StrategyName.AUTOBUDGET_ROI, GdStrategyName.AUTOBUDGET_ROI)
                    .put(StrategyName.CPM_DEFAULT, GdStrategyName.CPM_DEFAULT)
                    .put(StrategyName.AUTOBUDGET_MAX_REACH, GdStrategyName.AUTOBUDGET_MAX_REACH)
                    .put(StrategyName.AUTOBUDGET_MAX_IMPRESSIONS, GdStrategyName.AUTOBUDGET_MAX_IMPRESSIONS)
                    .put(StrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD,
                            GdStrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD)
                    .put(StrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD,
                            GdStrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD)
                    .put(StrategyName.PERIOD_FIX_BID, GdStrategyName.PERIOD_FIX_BID)
                    .put(StrategyName.AUTOBUDGET_AVG_CPV, GdStrategyName.AUTOBUDGET_AVG_CPV)
                    .put(StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD,
                            GdStrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD)
                    .put(StrategyName.AUTOBUDGET_CRR, GdStrategyName.AUTOBUDGET_CRR)
                    .put(StrategyName.UNKNOWN, GdStrategyName.UNKNOWN)
                    .build();
    private static final BiMap<GdStrategyName, StrategyName> toSourceMap = fromSourceMap.inverse();

    public static GdStrategyName fromSource(StrategyName value) {
        return getFromMap(fromSourceMap, value);
    }

    public static StrategyName toSource(GdStrategyName value) {
        return getFromMap(toSourceMap, value);
    }

    private static <K, V> V getFromMap(Map<K, V> map, K key) {
        if (key == null || map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalStateException("No such value: " + key);
    }
}
