package ru.yandex.direct.grid.model.utils;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagType;
import ru.yandex.direct.grid.model.moderation.GdModerationReasonType;

@ParametersAreNonnullByDefault
public class GridModerationUtils {
    private GridModerationUtils() {
    }

    public static GdModerationReasonType toGdModerationReasonType(ModerationDiagType moderationDiagType) {
        switch (moderationDiagType) {
            case COMMON:
                return GdModerationReasonType.COMMON;
            case PERFORMANCE:
                return GdModerationReasonType.PERFORMANCE;
            default:
                throw new IllegalArgumentException("Unknown ModerationDiagType value: " + moderationDiagType.name());
        }
    }

    public static ModerationDiagType fromGdModerationReasonType(GdModerationReasonType gdModerationReasonType) {
        switch (gdModerationReasonType) {
            case COMMON:
                return ModerationDiagType.COMMON;
            case PERFORMANCE:
                return ModerationDiagType.PERFORMANCE;
            default:
                throw new IllegalArgumentException("Unknown GdModerationReasonType value: " + gdModerationReasonType.name());
        }
    }

    public static Map<GdModerationReasonType, Set<Long>> toGdRejectReasons(Map<ModerationDiagType, Set<Long>> rejectReasons) {
        return EntryStream.of(rejectReasons).mapKeys(GridModerationUtils::toGdModerationReasonType).toMap();
    }

    public static Map<ModerationDiagType, Set<Long>> fromGdRejectReasons(Map<GdModerationReasonType, Set<Long>> rejectReasons) {
        return EntryStream.of(rejectReasons).mapKeys(GridModerationUtils::fromGdModerationReasonType).toMap();
    }
}
