package ru.yandex.direct.grid.model.utils;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.time.model.TimeInterval;
import ru.yandex.direct.grid.model.GdTime;
import ru.yandex.direct.grid.model.GdTimeInterval;

@ParametersAreNonnullByDefault
public class GridTimeUtils {
    private GridTimeUtils() {
    }

    public static GdTimeInterval toGdTimeInterval(TimeInterval timeInterval) {
        return new GdTimeInterval()
                .withStartTime(new GdTime()
                        .withHour(timeInterval.getStartHour())
                        .withMinute(timeInterval.getStartMinute()))
                .withEndTime(new GdTime()
                        .withHour(timeInterval.getEndHour())
                        .withMinute(timeInterval.getEndMinute()));
    }

}
