package ru.yandex.direct.grid.processing.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Service;

/**
 * Аннотация, включающая логирование результата мутации, если в ней были ошибки валидации
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Service
public @interface EnableLoggingOnValidationIssues {
}
