package ru.yandex.direct.grid.processing.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Service;

/**
 * Аннотация, для отметки сервисов, обрабатывающих запросы GraphQL. Все сервисы, помеченные этой аннотацией, будут
 * переданы {@link ru.yandex.direct.grid.processing.processor.GridGraphQLProcessor} при инициализации последнего
 * и добавлены в схему GraphQL.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Service
public @interface GridGraphQLService {
    /**
     * Поднятый флаг обозначает, что сервис предназначен для разработчиков (добавляются в схемк только на бетах)
     */
    boolean isBeta() default false;
}
