package ru.yandex.direct.grid.processing.exception;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.ErrorCodes;
import ru.yandex.direct.validation.result.DefectId;

/**
 * Список кодов исключений из TranslatableException, для которых необходимо пробрасывать код ошбибки во фронтенд.
 */
@ParametersAreNonnullByDefault
public enum GdExceptions implements DefectId<Void> {
    NO_RIGHTS(ErrorCodes.NO_RIGHTS),
    TYCOON_SERVICE_UNAVAILABLE(ErrorCodes.TYCOON_SERVICE_UNAVAILABLE),
    ACCESS_DENIED(GridErrors.ACCESS_DENIED);

    private int errorCode;

    GdExceptions(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getIntegerErrorCode() {
        return errorCode;
    }

    public static GdExceptions fromCode(int errorCode) {
        for (GdExceptions code : values()) {
            if (code.getIntegerErrorCode() == errorCode) {
                return code;
            }
        }
        return null;
    }
}
