package ru.yandex.direct.grid.processing.exception;

import ru.yandex.direct.core.TranslatableException;
import ru.yandex.direct.i18n.Translatable;

/**
 * Исключение, содержащее сообщение, которое можно показывать конечному пользователю
 */
public class GridPublicException extends TranslatableException {
    private final Translatable detailedMessage;

    public GridPublicException(GdExceptions gdException, String internalMessage, Translatable detailedMessage) {
        super(internalMessage, gdException.getIntegerErrorCode(), detailedMessage, detailedMessage);
        this.detailedMessage = detailedMessage;
    }

    public Translatable getDetailedMessage() {
        return detailedMessage;
    }
}
