package ru.yandex.direct.grid.processing.exception;

import ru.yandex.direct.grid.processing.model.api.GdValidationResult;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Ошибка валидации входящих в гриды данных
 */
public class GridValidationException extends RuntimeException {
    private final GdValidationResult validationResult;

    public GridValidationException(GdValidationResult validationResult) {
        checkNotNull(validationResult);
        this.validationResult = validationResult;
    }

    @Override
    public String getMessage() {
        return validationResult.toString();
    }

    public GdValidationResult getValidationResult() {
        return validationResult;
    }
}
