package ru.yandex.direct.grid.processing.model.campaign

import io.leangen.graphql.annotations.GraphQLNonNull
import ru.yandex.direct.currency.CurrencyCode
import ru.yandex.direct.grid.processing.container.agency.GdAgencyInfo
import ru.yandex.direct.grid.processing.model.api.GdApiResponse
import ru.yandex.direct.grid.processing.model.client.GdUserInfo

/**
 * Копирование кампаний клиентом
 */
class GdCopyCampaigns(
    val campaignIds: @GraphQLNonNull List<@GraphQLNonNull Long>,
)

class GdCopyCampaignsPayload(
    val campaignIdsToCopy: List<@GraphQLNonNull Long>,
) : GdApiResponse()


open class GdCopyCampaignsInterclientBase(
    val loginFrom: @GraphQLNonNull String,
    val loginTo: @GraphQLNonNull String,
)

/**
 * Предварительный запрос со страницы копирования кампаний
 */
class GdCheckCopyCampaigns(
    loginFrom: @GraphQLNonNull String,
    loginTo: @GraphQLNonNull String,
) : GdCopyCampaignsInterclientBase(loginFrom = loginFrom, loginTo = loginTo)

class GdCheckCopyCampaignsPayload(
    val currencyChangeTo: CurrencyCode?,

    @Deprecated("оставлено для совместимости схемы")
    val servicingOptions: @GraphQLNonNull GdCopyCampaignsServicingOptions = GdCopyCampaignsServicingOptions(),
) : GdApiResponse()

@Deprecated("оставлено для совместимости схемы")
class GdCopyCampaignsServicingOptions(
    val allowSelfServiced: @GraphQLNonNull Boolean = false,
    val allowServicedByManager: @GraphQLNonNull Boolean = false,

    val agencies: @GraphQLNonNull List<GdAgencyInfo> = listOf(),
    val managers: @GraphQLNonNull List<GdUserInfo> = listOf(),
)

/**
 * Запрос копирования со страницы копирования кампаний
 */
class GdCopyCampaignsInterclient(
    loginFrom: @GraphQLNonNull String,
    loginTo: @GraphQLNonNull String,

    val filter: @GraphQLNonNull GdCopyCampaignsFilter,
    val flags: @GraphQLNonNull GdCopyCampaignsFlags = GdCopyCampaignsFlags(),

    @Deprecated("оставлено для совместимости схемы")
    val agencyUserId: Long? = null,
    @Deprecated("оставлено для совместимости схемы")
    val managerUserId: Long? = null,
) : GdCopyCampaignsInterclientBase(loginFrom = loginFrom, loginTo = loginTo)

class GdCopyCampaignsInterclientPayload(
    val campaignIdsToCopy: List<@GraphQLNonNull Long>,
    val skippedCampaignIds: List<@GraphQLNonNull Long>,
    val copiedCampaignId: Long?,
) : GdApiResponse()


class GdCopyCampaignsFlags(
    val copyStoppedAds: @GraphQLNonNull Boolean = false,
    val copyArchivedAds: @GraphQLNonNull Boolean = false,
    val copyStatuses: @GraphQLNonNull Boolean = false,
    val copyShowConditionStatuses: @GraphQLNonNull Boolean = false,
    val copyConversionStrategy: @GraphQLNonNull Boolean = false,
    val dontCopyLibraryMinusKeywords: @GraphQLNonNull Boolean = false,
    val stopCopiedCampaigns: @GraphQLNonNull Boolean = false,
    val generateReport: @GraphQLNonNull Boolean = false,
)

class GdCopyCampaignsFilter(
    val campaignIds: List<@GraphQLNonNull Long>? = null,
    val campaignsType: GdCopyCampaignsSelectorType? = null,
)

enum class GdCopyCampaignsSelectorType {
    /**
     * Скопировать только активные кампании
     */
    ACTIVE,

    /**
     * Скопировать только остановленные кампании
     */
    STOPPED,

    /**
     * Скопировать только черновики
     */
    DRAFT,

    /**
     * Скопировать все архивные кампании
     */
    ARCHIVED,

    /**
     * Скопировать все кампании
     */
    ALL,
}
