package ru.yandex.direct.grid.processing.model.common;

import java.util.List;
import java.util.Objects;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.service.cache.CachedGridData;

/**
 * Общий класс для вывода preview информации массовых изменений в GraphQL
 *
 * @param <T> - тип результата
 */
public class GdCachedResult<T> extends GdResult<T> implements CachedGridData<T> {
    @GraphQLNonNull
    private String cacheKey;

    @Override
    public GdCachedResult<T> withValidationResult(GdValidationResult validationResult) {
        setValidationResult(validationResult);
        return this;
    }

    @GraphQLNonNull
    public String getCacheKey() {
        return cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public GdCachedResult<T> withCacheKey(String cacheKey) {
        setCacheKey(cacheKey);
        return this;
    }

    @Override
    public GdCachedResult<T> withTotalCount(Integer totalCount) {
        setTotalCount(totalCount);
        return this;
    }

    @Override
    public GdCachedResult<T> withRowset(List<@GraphQLNonNull T> rowset) {
        setRowset(rowset);
        return this;
    }

    @Override
    public GdCachedResult<T> withSuccessCount(Integer successCount) {
        setSuccessCount(successCount);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GdCachedResult<?> gdCachedResult = (GdCachedResult<?>) o;
        return Objects.equals(cacheKey, gdCachedResult.cacheKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), cacheKey);
    }
}
