package ru.yandex.direct.grid.processing.model.common;

import java.util.List;
import java.util.Objects;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.grid.processing.model.api.GdApiResponse;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;

/**
 * Общий класс для вывода информации о результате массовых изменений в GraphQL
 *
 * @param <T> - тип результата
 */
public class GdResult<T> extends GdApiResponse {

    @GraphQLNonNull
    private Integer totalCount;

    @GraphQLNonNull
    private Integer successCount;

    @GraphQLNonNull
    private List<@GraphQLNonNull T> rowset;

    @Override
    public GdResult<T> withValidationResult(GdValidationResult validationResult) {
        setValidationResult(validationResult);
        return this;
    }

    @GraphQLNonNull
    public Integer getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    public GdResult<T> withSuccessCount(Integer successCount) {
        setSuccessCount(successCount);
        return this;
    }

    @GraphQLNonNull
    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public GdResult<T> withTotalCount(Integer totalCount) {
        setTotalCount(totalCount);
        return this;
    }

    @GraphQLNonNull
    public List<T> getRowset() {
        return rowset;
    }

    public void setRowset(List<@GraphQLNonNull T> rowset) {
        this.rowset = rowset;
    }

    public GdResult<T> withRowset(List<@GraphQLNonNull T> rowset) {
        setRowset(rowset);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GdResult<?> that = (GdResult<?>) o;
        return Objects.equals(totalCount, that.totalCount) &&
                Objects.equals(rowset, that.rowset);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                super.hashCode(),
                totalCount,
                rowset
        );
    }
}
