package ru.yandex.direct.grid.processing.model.common;

import java.util.List;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Модель для хранения списка rowset и соответствующего ValidationResult
 */
public class GdiOperationResult<T, R> {
    private final List<T> rowset;
    private final ValidationResult<List<R>, Defect> validationResult;

    public GdiOperationResult(List<T> rowset,
                              ValidationResult<List<R>, Defect> validationResult) {
        this.rowset = rowset;
        this.validationResult = validationResult;
    }

    public List<T> getRowset() {
        return rowset;
    }

    public ValidationResult<List<R>, Defect> getValidationResult() {
        return validationResult;
    }
}
