package ru.yandex.direct.grid.processing.model.constants;

import javax.annotation.Nullable;

import ru.yandex.direct.i18n.Language;

public enum GdLanguage {
    EN,
    TR,
    RU,
    UK;

    @Nullable
    public static GdLanguage fromSource(Language value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case EN:
                return EN;
            case TR:
                return TR;
            case RU:
                return RU;
            case UK:
                return UK;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Nullable
    public static Language toSource(GdLanguage value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case EN:
                return Language.EN;
            case TR:
                return Language.TR;
            case RU:
                return Language.RU;
            case UK:
                return Language.UK;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }
}
