package ru.yandex.direct.grid.processing.model.money;

import java.math.BigDecimal;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;

/**
 * Класс-обёртка для представления {@link Money} в GraphQL.
 */
public class GdMoney {
    private final Money money;

    public GdMoney(Money money) {
        this.money = money;
    }

    @GraphQLNonNull
    public BigDecimal getValue() {
        return money.bigDecimalValue();
    }

    @GraphQLNonNull
    public CurrencyCode getCode() {
        return money.getCurrencyCode();
    }

    /**
     * Представление численного значения как типа {@code Float} в GraphQL.
     * {@link BigDecimal} на фронте мапится в строчку, с которой не всегда удобно работать.
     */
    @GraphQLNonNull
    public Double getValueAsFloat() {
        return getValue().doubleValue();
    }
}
