package ru.yandex.direct.grid.processing.model.promoextension

import io.leangen.graphql.annotations.GraphQLNonNull
import java.time.LocalDate

data class GdAddPromoExtensionsInput(
    val promoExtensions: List<GdAddPromoExtensionItem>
)

data class GdUpdatePromoExtensionsInput(
    val promoExtensions: List<GdUpdatePromoExtensionItem>
)

data class GdDeletePromoExtensionsInput(
    val ids: List<@GraphQLNonNull Long>
)

data class GdUpdateCampaignsPromoExtension(
    val campaignIds: List<@GraphQLNonNull Long>,
    val promoExtensionId: Long?
)

data class GdAddPromoExtensionItem(
    val type: GdPromoExtensionType,
    val amount: Long?,
    val unit: GdPromoExtensionUnit?,
    val prefix: GdPromoExtensionPrefix?,
    val href: String?,
    val description: String,
    val startDate: LocalDate?,
    val finishDate: LocalDate?,
)

data class GdUpdatePromoExtensionItem(
    val id: Long,
    val type: GdPromoExtensionType,
    val amount: Long?,
    val unit: GdPromoExtensionUnit?,
    val prefix: GdPromoExtensionPrefix?,
    val href: String?,
    val description: String,
    val startDate: LocalDate?,
    val finishDate: LocalDate?,
)

data class GdPromoExtensionPayloadItem(
    val id: Long?, //null, если добавить не удалось
    val promoExtension: GdPromoExtension?, //null, если добавить не удалось
)
