package ru.yandex.direct.grid.processing.model.showcondition.mutation;

import java.util.ArrayList;
import java.util.List;


/**
 * Слово, полученное из Advq, с помощью которого предлагается уточнить фразу.
 */
public class RefinedWord {
    private final String word;
    /**
     * Примеры фраз, в котором это слово используется.
     */
    private final List<String> phrases;
    /**
     * Количество показов этого слова.
     */
    private final long count;

    public RefinedWord(String word, List<String> phrases, long count) {
        this.word = word;
        this.phrases = phrases;
        this.count = count;
    }

    public String getWord() {
        return word;
    }

    public List<String> getPhrases() {
        return phrases;
    }

    public long getCount() {
        return count;
    }

    public RefinedWord union(RefinedWord item) {
        List<String> newPhrases = new ArrayList<>(phrases.size() + item.phrases.size());
        newPhrases.addAll(phrases);
        newPhrases.addAll(item.phrases);
        long newCount = count + item.count;
        return new RefinedWord(word, newPhrases, newCount);
    }
}
