package ru.yandex.direct.grid.processing.model.showcondition.mutation;

import java.util.ArrayList;
import java.util.List;

/**
 * Класс, в котором накапливается статистика по слову, с помощью которого предлагается уточнить фразу.
 */
public class RefinedWordAcc {
    /**
     * Примеры фраз, в котором это слово используется.
     */
    private List<String> phrases = new ArrayList<>();
    /**
     * Сумма показов фраз, в котором это слово используется.
     */
    private long count;
    /**
     * Точное количество показов этого слова. Точное количество удается определить,
     * если в примерах фраз попадается фраза (за вычетом минус-слов и слов, которые вычитают ключевую фразу),
     * которая совпадает со словом.
     */
    private long exactCount;

    private RefinedWordAcc(String phrase, long count, long exactCount) {
        phrases.add(phrase);
        this.count = count;
        this.exactCount = exactCount;
    }

    private RefinedWordAcc(List<String> phrases, long count, long exactCount) {
        this.phrases = new ArrayList<>(phrases);
        this.count = count;
        this.exactCount = exactCount;
    }

    public List<String> getPhrases() {
        return phrases;
    }

    public static RefinedWordAcc newExactRefinedWordAcc(String phrase, long exactCount) {
        return new RefinedWordAcc(phrase, exactCount, exactCount);
    }

    public static RefinedWordAcc newRefinedWordAcc(String phrase, long count) {
        return new RefinedWordAcc(phrase, count, 0L);
    }

    public static RefinedWordAcc copyRefinedWordAcc(RefinedWordAcc acc) {
        return new RefinedWordAcc(acc.phrases, acc.count, acc.exactCount);
    }

    public RefinedWordAcc add(RefinedWordAcc item) {
        phrases.addAll(item.phrases);
        count += item.count;
        exactCount = Math.max(item.exactCount, exactCount);
        return this;
    }

    public long getEffectiveCount() {
        return exactCount > 0 ? exactCount : count;
    }
}
