package ru.yandex.direct.grid.processing.processor;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import graphql.execution.ResultPath;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;

import ru.yandex.direct.common.lettuce.LettuceConnectionProvider;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;

import static ru.yandex.direct.grid.processing.processor.util.InstrumentationUtil.getMethodName;


/**
 * Инструментарий, профилирующий все запросы к полям, содержащим аннотацию {@link GraphQLRateLimit}
 */
@ParametersAreNonnullByDefault
public class GridRateLimitInstrumentation extends SimpleInstrumentation {

    private final RateLimitHandler rateLimit;
    private final Map<ResultPath, GraphQLRateLimit> methodsWithAnnotation;

    GridRateLimitInstrumentation(LettuceConnectionProvider lettuce,
                                 Map<ResultPath, GraphQLRateLimit> methodsWithAnnotation) {
        rateLimit = new RateLimitHandler(lettuce);
        this.methodsWithAnnotation = methodsWithAnnotation;
    }

    @Override
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        GraphQLRateLimit rateLimitMethod = methodsWithAnnotation.get(parameters.getExecutionStepInfo().getPath());
        if (rateLimitMethod != null) {
            String methodName = getMethodName(parameters);
            GridGraphQLContext context = parameters.getExecutionContext().getContext();
            User subjectUser = context.getSubjectUser();
            rateLimit.handleRequest(subjectUser.getClientId().asLong(), methodName, rateLimitMethod);
        }
        return new SimpleInstrumentationContext<>();
    }
}
