package ru.yandex.direct.grid.processing.processor

import graphql.schema.GraphQLInputObjectType
import graphql.schema.GraphQLInputType
import graphql.schema.GraphQLNonNull
import io.leangen.graphql.generator.mapping.TypeMapper
import io.leangen.graphql.generator.mapping.TypeMappingEnvironment
import io.leangen.graphql.generator.mapping.common.ObjectTypeMapper
import io.leangen.graphql.metadata.messages.MessageBundle
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import java.lang.reflect.AnnotatedType

// при обновлении spqr 0.9.9 -> 0.11.2 изменилась генерация имён типов для коллекций. В dna завязались на старые имена, поэтому возвращаем их здесь.
class NamePatchingTypeInfoGenerator : DefaultTypeInfoGenerator() {
    public override fun generateTypeName(type: AnnotatedType, messageBundle: MessageBundle) : String {
        return when (val originalName = super.generateTypeName(type, messageBundle)) {
            "Map_GdCreativeType_List_Long" -> "Map_GdCreativeType_List"
            "Map_GdRelevanceMatchCategory_List_String" -> "Map_GdRelevanceMatchCategory_List"
            "Map_Long_Set_CurrencyCode" -> "Map_Long_Set"
            else -> originalName
        }
    }
}
