package ru.yandex.direct.grid.processing.processor.util;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import graphql.language.Field;
import graphql.language.FragmentDefinition;
import io.leangen.graphql.execution.ResolutionEnvironment;

import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.AdFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.AdGroupFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.CampaignFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.CampaignGoalFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.DynamicTargetFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.FetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.OfferFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.PackageStrategyFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.RetargetingFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.ShowConditionFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.SmartFilterFetchedFieldsResolver;
import ru.yandex.direct.grid.core.entity.fetchedfieldresolver.WalletFetchedFieldsResolver;
import ru.yandex.direct.grid.model.campaign.GdCampaign;
import ru.yandex.direct.grid.processing.model.banner.GdAd;
import ru.yandex.direct.grid.processing.model.campaign.GdCampaignsContext;
import ru.yandex.direct.grid.processing.model.campaign.GdWallet;
import ru.yandex.direct.grid.processing.model.dynamiccondition.GdDynamicAdTargetsContext;
import ru.yandex.direct.grid.processing.model.goal.GdGoal;
import ru.yandex.direct.grid.processing.model.group.GdAdGroup;
import ru.yandex.direct.grid.processing.model.retargeting.GdRetargeting;
import ru.yandex.direct.grid.processing.model.showcondition.GdKeyword;
import ru.yandex.direct.grid.processing.model.smartfilter.GdSmartFiltersContext;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.grid.processing.processor.util.FetchedFieldsResolverUtil.getChildField;
import static ru.yandex.direct.grid.processing.processor.util.FetchedFieldsResolverUtil.hasChildField;
import static ru.yandex.direct.grid.processing.processor.util.FetchedFieldsResolverUtil.presentChildFields;
import static ru.yandex.direct.grid.processing.service.banner.AdGraphQlService.ADS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.campaign.CampaignsGraphQlService.CAMPAIGNS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.campaign.CampaignsGraphQlService.WALLETS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.client.ClientFeatureCalculator.FEATURES_DEPENDS_ON_CAMPAIGNS;
import static ru.yandex.direct.grid.processing.service.client.ClientGraphQlService.CLIENT_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.client.ClientGraphQlService.FEATURES_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.dynamiccondition.DynamicConditionsGraphQlService.DYNAMIC_AD_TARGETS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.goal.GoalGraphQlService.CAMPAIGN_GOALS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.group.AdGroupGraphQlService.AD_GROUPS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.offer.OfferGraphQlService.OFFERS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.showcondition.RetargetingGraphQlService.RETARGETING_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.showcondition.ShowConditionGraphQlService.SHOW_CONDITIONS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.smartfilter.SmartFilterGraphQlService.SMART_FILTERS_RESOLVER_NAME;
import static ru.yandex.direct.grid.processing.service.strategy.PackageStrategyGraphQlService.STRATEGIES_RESOLVER_NAME;

@ParametersAreNonnullByDefault
public class ClientResolverFetchedFieldsUtil {

    private static final String ROWSET_FIELD_NAME = GdCampaignsContext.ROWSET.name();
    private static final String STATS_FIELD_NAME = GdCampaign.STATS.name();
    private static final String GOAL_STATS_FIELD_NAME = GdCampaign.GOAL_STATS.name();
    private static final String CACHE_KEY_FIELD_NAME = GdCampaignsContext.CACHE_KEY.name();
    private static final String RECOMMENDATIONS_FIELD_NAME = GdCampaign.RECOMMENDATIONS.name();
    private static final String TAGS_FIELD_NAME = GdAdGroup.TAGS.name();
    private static final String AUCTION_DATA_FIELD_NAME = GdKeyword.AUCTION_DATA.name();
    private static final String POKAZOMETER_DATA_FIELD_NAME = GdKeyword.POKAZOMETER_DATA.name();
    private static final String PAID_DAYS_LEFT_FIELD_NAME = GdWallet.PAID_DAYS_LEFT.name();
    private static final String STATS_BY_DAYS_FIELD_NAME = GdAd.STATS_BY_DAYS.name();
    private static final String DOMAIN_FIELD_NAME = GdGoal.DOMAIN.name();

    /**
     * FetchedFieldsResolver содержит в себе знания, запрошены ли определенные поля из интерфейса.
     * В некоторых случаях можно получить приличный буст производительности не рассчитывая не нужные поля
     */
    public static FetchedFieldsResolver resolve(ResolutionEnvironment environment) {
        Field clientField = environment.dataFetchingEnvironment.getField();
        checkState(CLIENT_RESOLVER_NAME.equals(clientField.getName()), "expect client resolver");

        Map<String, FragmentDefinition> fragmentsByName = environment.dataFetchingEnvironment.getFragmentsByName();

        return new FetchedFieldsResolver()
                .withCampaign(getCampaignFetchedFieldsResolver(clientField, fragmentsByName))
                .withCampaignGoal(getCampaignGoalFetchedFieldsResolver(clientField, fragmentsByName))
                .withAdGroup(getAdGroupFetchedFieldsResolver(clientField, fragmentsByName))
                .withAd(getAdFetchedFieldsResolver(clientField, fragmentsByName))
                .withShowCondition(getShowConditionFetchedFieldsResolver(clientField, fragmentsByName))
                .withRetargeting(getRetargetingFetchedFields(clientField, fragmentsByName))
                .withDynamicTarget(getDynamicTargetFetchedFields(clientField, fragmentsByName))
                .withSmartFilter(getSmartFilterFetchedFields(clientField, fragmentsByName))
                .withWallet(getWalletFetchedFields(clientField, fragmentsByName))
                .withOffer(getOfferFetchedFields(clientField, fragmentsByName))
                .withPackageStrategy(getPackageStrategyFetchedFields(clientField, fragmentsByName));
    }

    private static CampaignFetchedFieldsResolver getCampaignFetchedFieldsResolver(Field clientField,
                                                                                  Map<String, FragmentDefinition> fragmentsByName) {
        Field campaignsField = getChildField(CAMPAIGNS_RESOLVER_NAME, clientField, fragmentsByName);
        Field campaignsRowsetField = getChildField(ROWSET_FIELD_NAME, campaignsField, fragmentsByName);

        return new CampaignFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, campaignsRowsetField, fragmentsByName))
                .withRecommendations(hasChildField(RECOMMENDATIONS_FIELD_NAME, campaignsRowsetField, fragmentsByName))
                .withCacheKey(hasChildField(CACHE_KEY_FIELD_NAME, campaignsField, fragmentsByName));
    }

    private static CampaignGoalFetchedFieldsResolver getCampaignGoalFetchedFieldsResolver(Field clientField,
                                                                                          Map<String,
                                                                                                  FragmentDefinition> fragmentsByName) {
        Field campaignGoalsField = getChildField(CAMPAIGN_GOALS_RESOLVER_NAME, clientField, fragmentsByName);
        Field campaignGoalsRowsetField = getChildField(ROWSET_FIELD_NAME, campaignGoalsField, fragmentsByName);

        return new CampaignGoalFetchedFieldsResolver()
                .withDomain(hasChildField(DOMAIN_FIELD_NAME, campaignGoalsRowsetField, fragmentsByName));
    }

    private static AdFetchedFieldsResolver getAdFetchedFieldsResolver(Field clientField,
                                                                      Map<String, FragmentDefinition> fragmentsByName) {
        Field adsField = getChildField(ADS_RESOLVER_NAME, clientField, fragmentsByName);
        Field adsRowsetField = getChildField(ROWSET_FIELD_NAME, adsField, fragmentsByName);

        return new AdFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, adsRowsetField, fragmentsByName))
                .withStatsByDays(hasChildField(STATS_BY_DAYS_FIELD_NAME, adsRowsetField, fragmentsByName))
                .withRecommendations(hasChildField(RECOMMENDATIONS_FIELD_NAME, adsRowsetField, fragmentsByName))
                .withCacheKey(hasChildField(CACHE_KEY_FIELD_NAME, adsField, fragmentsByName));
    }

    private static AdGroupFetchedFieldsResolver getAdGroupFetchedFieldsResolver(Field clientField,
                                                                                Map<String, FragmentDefinition> fragmentsByName) {
        Field adGroupsField = getChildField(AD_GROUPS_RESOLVER_NAME, clientField, fragmentsByName);

        Field adGroupsRowsetField = getChildField(ROWSET_FIELD_NAME, adGroupsField, fragmentsByName);
        return new AdGroupFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, adGroupsRowsetField, fragmentsByName))
                .withRecommendations(hasChildField(RECOMMENDATIONS_FIELD_NAME, adGroupsRowsetField, fragmentsByName))
                .withCacheKey(hasChildField(CACHE_KEY_FIELD_NAME, adGroupsField, fragmentsByName))
                .withTags(hasChildField(TAGS_FIELD_NAME, adGroupsRowsetField, fragmentsByName));
    }

    private static ShowConditionFetchedFieldsResolver getShowConditionFetchedFieldsResolver(Field clientField,
                                                                                            Map<String,
                                                                                                    FragmentDefinition> fragmentsByName) {
        Field showConditionsField = getChildField(SHOW_CONDITIONS_RESOLVER_NAME, clientField, fragmentsByName);

        Field showConditionsRowsetField = getChildField(ROWSET_FIELD_NAME, showConditionsField, fragmentsByName);
        return new ShowConditionFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, showConditionsRowsetField, fragmentsByName))
                .withAuctionData(hasChildField(AUCTION_DATA_FIELD_NAME, showConditionsRowsetField, fragmentsByName))
                .withPokazometrData(
                        hasChildField(POKAZOMETER_DATA_FIELD_NAME, showConditionsRowsetField, fragmentsByName))
                .withCacheKey(hasChildField(CACHE_KEY_FIELD_NAME, showConditionsField, fragmentsByName));
    }

    private static RetargetingFetchedFieldsResolver getRetargetingFetchedFields(Field clientField,
                                                                                Map<String, FragmentDefinition> fragmentsByName) {
        Field retargetingField = getChildField(RETARGETING_RESOLVER_NAME, clientField, fragmentsByName);
        Field retargetingRowsetField = getChildField(ROWSET_FIELD_NAME, retargetingField, fragmentsByName);
        return new RetargetingFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, retargetingRowsetField, fragmentsByName))
                .withRetargetingCondition(
                        hasChildField(GdRetargeting.RETARGETING_CONDITION.name(), retargetingRowsetField,
                                fragmentsByName))
                .withCacheKey(hasChildField(CACHE_KEY_FIELD_NAME, retargetingField, fragmentsByName));
    }

    private static DynamicTargetFetchedFieldsResolver getDynamicTargetFetchedFields(Field clientField,
                                                                                    Map<String, FragmentDefinition> fragmentsByName) {
        Field dynamicTargetsField = getChildField(DYNAMIC_AD_TARGETS_RESOLVER_NAME, clientField, fragmentsByName);
        Field retargetingRowsetField =
                getChildField(GdDynamicAdTargetsContext.ROWSET.name(), dynamicTargetsField, fragmentsByName);
        return new DynamicTargetFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, retargetingRowsetField, fragmentsByName))
                .withGoalStats(hasChildField(GOAL_STATS_FIELD_NAME, retargetingRowsetField, fragmentsByName));
    }

    private static SmartFilterFetchedFieldsResolver getSmartFilterFetchedFields(Field clientField,
                                                                                Map<String, FragmentDefinition> fragmentsByName) {
        Field smartFiltersField = getChildField(SMART_FILTERS_RESOLVER_NAME, clientField, fragmentsByName);
        Field retargetingRowsetField =
                getChildField(GdSmartFiltersContext.ROWSET.name(), smartFiltersField, fragmentsByName);
        return new SmartFilterFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, retargetingRowsetField, fragmentsByName));
    }

    private static WalletFetchedFieldsResolver getWalletFetchedFields(Field clientField,
                                                                      Map<String, FragmentDefinition> fragmentsByName) {
        Field walletsField = getChildField(WALLETS_RESOLVER_NAME, clientField, fragmentsByName);
        return new WalletFetchedFieldsResolver()
                .withPaidDaysLeft(hasChildField(PAID_DAYS_LEFT_FIELD_NAME, walletsField, fragmentsByName));
    }

    private static OfferFetchedFieldsResolver getOfferFetchedFields(Field clientField,
                                                                    Map<String, FragmentDefinition> fragmentsByName) {
        Field offersField = getChildField(OFFERS_RESOLVER_NAME, clientField, fragmentsByName);
        Field offersRowsetField = getChildField(ROWSET_FIELD_NAME, offersField, fragmentsByName);
        return new OfferFetchedFieldsResolver()
                .withStats(hasChildField(STATS_FIELD_NAME, offersRowsetField, fragmentsByName))
                .withCacheKey(hasChildField(CACHE_KEY_FIELD_NAME, offersField, fragmentsByName));
    }

    private static PackageStrategyFetchedFieldsResolver getPackageStrategyFetchedFields(
            Field clientField,
            Map<String, FragmentDefinition> fragmentsByName) {
        Field packageStrategiesField = getChildField(STRATEGIES_RESOLVER_NAME, clientField, fragmentsByName);
        Field packageStrategiesRowset = getChildField(ROWSET_FIELD_NAME, packageStrategiesField, fragmentsByName);
        return new PackageStrategyFetchedFieldsResolver()
                .withCacheKey(hasChildField(CACHE_KEY_FIELD_NAME, packageStrategiesField, fragmentsByName))
                .withStats(hasChildField(STATS_FIELD_NAME, packageStrategiesRowset, fragmentsByName));
    }

    /**
     * Была ли запрошена хотя бы одна фича, зависящая от данных кампаний
     */
    public static boolean isAnyFeatureDependsOnCampaignsRequested(ResolutionEnvironment environment) {
        Field featuresField = environment.dataFetchingEnvironment.getField();
        checkState(FEATURES_RESOLVER_NAME.equals(featuresField.getName()), "expect features resolver");
        Map<String, FragmentDefinition> fragmentsByName = environment.dataFetchingEnvironment.getFragmentsByName();
        Set<String> presentCampaignFeatures =
                presentChildFields(FEATURES_DEPENDS_ON_CAMPAIGNS, featuresField, fragmentsByName);
        return !presentCampaignFeatures.isEmpty();
    }
}
