package ru.yandex.direct.grid.processing.processor.util;

import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import kotlin.reflect.KProperty1;

import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class GridRequestedFieldsHolder {
    @Nullable
    private final Set<String> requestedFields;

    public GridRequestedFieldsHolder(@Nullable Set<String> requestedFields) {
        this.requestedFields = requestedFields;
    }

    @Nonnull
    public Set<String> getRequestedFields() {
        return nvl(requestedFields, Set.of());
    }

    public boolean isKPropertyPresent(KProperty1<?, ?> property) {
        return requestedFields != null && requestedFields.contains(property.getName());
    }

    @Nonnull
    public Set<ModelProperty<?, ?>> getRequestedModelFields(Set<ModelProperty<?, ?>> allPossibleValues) {
        if (requestedFields == null) {
            return Set.of();
        }
        return allPossibleValues
                .stream()
                .filter(t -> requestedFields.contains(t.name()))
                .collect(Collectors.toSet());
    }
}
