package ru.yandex.direct.grid.processing.processor.util;

import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Set;

import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.generator.mapping.ArgumentInjectorParams;
import io.leangen.graphql.generator.mapping.common.InputValueDeserializer;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.grid.processing.processor.util.FetchedFieldsResolverUtil.getChildField;
import static ru.yandex.direct.grid.processing.processor.util.FetchedFieldsResolverUtil.presentChildFields;

public class GridRequestedFieldsInjector extends InputValueDeserializer {
    @Override
    public Object getArgumentValue(ArgumentInjectorParams params) {
        checkState(params.getInput() == null, "not expected on input");
        checkState(params.getParameter() != null, "not expecting null as parameter");
        String[] pathToField = params.getParameter().getAnnotation(GridRequestedFields.class).childFieldPath();
        return new GridRequestedFieldsHolder(
                getRequestedFields(params.getResolutionEnvironment().dataFetchingEnvironment, pathToField));
    }

    @Override
    public boolean supports(AnnotatedType type, Parameter parameter) {
        return parameter != null && parameter.isAnnotationPresent(GridRequestedFields.class)
                && !parameter.isAnnotationPresent(GraphQLArgument.class)
                && parameter.getType().isAssignableFrom(GridRequestedFieldsHolder.class);
    }

    private static Set<String> getRequestedFields(DataFetchingEnvironment dataFetchingEnvironment, String[] pathToField) {
        Map<String, FragmentDefinition> fragmentsByName = dataFetchingEnvironment.getFragmentsByName();
        Field requestedField = dataFetchingEnvironment.getField();
        for (String pathElement: pathToField) {
            requestedField = getChildField(pathElement, requestedField, fragmentsByName);
        }
        return presentChildFields(requestedField, fragmentsByName);
    }
}
