package ru.yandex.direct.grid.processing.service.aggregatedstatuses;

import java.util.Comparator;

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReasonComparator;
import ru.yandex.direct.grid.model.aggregatedstatuses.GdStatusCounter;

public class GdStatusCountersComparator implements Comparator<GdStatusCounter> {
    @Override
    public int compare(GdStatusCounter o1, GdStatusCounter o2) {
        final var firstReasons = o1.getReasons();
        final var secondReasons = o2.getReasons();

        if (firstReasons == null || firstReasons.size() == 0) {
            return 1;
        }

        if (secondReasons == null || secondReasons.size() == 0) {
            return -1;
        }

        return new GdSelfStatusReasonComparator().compare(firstReasons.get(0), secondReasons.get(0));
    }
}
