package ru.yandex.direct.grid.processing.service.aggregatedstatuses;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;
import ru.yandex.direct.grid.model.aggregatedstatuses.GdModerationDiagData;

@ParametersAreNonnullByDefault
public final class SelfStatusWithModerationDiags {
    private final SelfStatus selfStatus;
    private final List<GdModerationDiagData> moderationDiags;

    public SelfStatusWithModerationDiags(SelfStatus selfStatus, List<GdModerationDiagData> moderationDiags) {
        this.selfStatus = selfStatus;
        this.moderationDiags = moderationDiags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SelfStatusWithModerationDiags that = (SelfStatusWithModerationDiags) o;
        return selfStatus.equals(that.selfStatus) && moderationDiags.equals(that.moderationDiags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(selfStatus, moderationDiags);
    }
}
