package ru.yandex.direct.grid.processing.service.attributes;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.abac.Attribute;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;

@Service
@ParametersAreNonnullByDefault
public class AttributeResolverService {
    private final DirectWebAuthenticationSource directWebAuthenticationSource;
    private final FeatureService featureService;

    @Autowired
    public AttributeResolverService(DirectWebAuthenticationSource directWebAuthenticationSource,
                                    FeatureService featureService) {
        this.directWebAuthenticationSource = directWebAuthenticationSource;
        this.featureService = featureService;
    }

    public boolean resolve(Attribute... values) {
        AttributeResolverContainer container =
                new AttributeResolverContainer(directWebAuthenticationSource.getAuthentication(), featureService);
        return Arrays.stream(values)
                .anyMatch(attribute -> AttributeRules.RULES.get(attribute).test(container));
    }

}
