package ru.yandex.direct.grid.processing.service.attributes;

import java.util.Map;
import java.util.function.Predicate;

import ru.yandex.direct.abac.Attribute;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.rbac.RbacRole;

import static java.util.Map.entry;
import static ru.yandex.direct.core.entity.pricepackage.service.PricePackagePermissionUtils.canApprovePricePackages;
import static ru.yandex.direct.core.entity.pricepackage.service.PricePackagePermissionUtils.canManagePricePackageClients;
import static ru.yandex.direct.core.entity.pricepackage.service.PricePackagePermissionUtils.canManagePricePackages;
import static ru.yandex.direct.core.entity.pricepackage.service.PricePackagePermissionUtils.canViewPricePackages;

public class AttributeRules {
    public static final Map<Attribute, Predicate<AttributeResolverContainer>> RULES = Map.ofEntries(
            entry(Attribute.CAN_EDIT_CAMPAIGN_CONTENT_LANGUAGE_BLOCK, operatorHasOneOfRoles(RbacRole.SUPER)),
            entry(Attribute.CAN_EDIT_CAMPAIGN_ATTRIBUTION_MODEL_BLOCK,
                    clientHasFeature(FeatureName.ATTRIBUTION_MODEL_IN_STRATEGY)),
            entry(Attribute.OPERATOR_HAS_SET_CAMPAIGN_ALLOWED_PAGE_IDS_FEATURE,
                    operatorHasFeature(FeatureName.SET_CAMPAIGN_ALLOWED_PAGE_IDS)),
            entry(Attribute.OPERATOR_HAS_SET_CAMPAIGN_DISALLOWED_PAGE_IDS_FEATURE,
                    operatorHasFeature(FeatureName.SET_CAMPAIGN_DISALLOWED_PAGE_IDS)),
            entry(Attribute.OPERATOR_HAS_GRID_FEATURE, operatorHasFeature(FeatureName.GRID)),
            entry(Attribute.CLIENT_CAN_CREATE_EXPERIMENT, clientHasFeature(FeatureName.AB_SEGMENTS)),
            entry(Attribute.CLIENT_CAN_CREATE_BRAND_LIFT, clientHasFeature(FeatureName.BRAND_LIFT)),
            entry(Attribute.CAN_OPEN_PRICE_PACKAGE_GRID,
                    c -> canViewPricePackages(c.getDirectAuthentication().getOperator())),
            entry(Attribute.MANAGE_PRICE_PACKAGES,
                    c -> canManagePricePackages(c.getDirectAuthentication().getOperator())),
            entry(Attribute.APPROVE_PRICE_PACKAGES,
                    c -> canApprovePricePackages(c.getDirectAuthentication().getOperator())),
            entry(Attribute.MANAGE_PRICE_PACKAGE_CLIENTS,
                    c -> canManagePricePackageClients(c.getDirectAuthentication().getOperator())),
            entry(Attribute.CAN_SET_BRANDSAFETY_CATEGORIES_CPM,
                    clientHasFeature(FeatureName.BRANDSAFETY_BASE_CATEGORIES_CPM)),
            entry(Attribute.CAN_SET_BRANDSAFETY_CATEGORIES_CPC,
                    clientHasFeature(FeatureName.BRANDSAFETY_BASE_CATEGORIES_CPC)),
            entry(Attribute.HAS_ACCESS_TO_COPY_PAGE,
                    clientHasFeature(FeatureName.USE_NEW_PAGE_FOR_COPY_CAMPAIGNS_BETWEEN_CLIENTS)),
            entry(Attribute.CLIENT_HAS_FEATURE_FOR_UPDATE_CAMPAIGN_METRIKA_COUNTERS,
                    clientHasFeature(FeatureName.MASS_EDIT_METRIKA_COUNTERS_IN_JAVA_FOR_DNA)),
            entry(Attribute.CAN_ENABLE_TURBO_APPS, clientHasFeature(FeatureName.TURBO_APP_ALLOWED))
    );

    private static Predicate<AttributeResolverContainer> operatorHasOneOfRoles(RbacRole... roles) {
        return c -> c.getDirectAuthentication().getOperator().getRole().anyOf(roles);
    }

    private static Predicate<AttributeResolverContainer> operatorHasFeature(FeatureName feature) {
        return c -> c.getFeatureService().getEnabledForUid(c.getDirectAuthentication().getOperator().getUid())
                .contains(feature.getName());
    }

    private static Predicate<AttributeResolverContainer> clientHasFeature(FeatureName feature) {
        return c -> c.getFeatureService().getEnabledForClientId(c.getDirectAuthentication().getSubjectUser().getClientId())
                .contains(feature.getName());
    }

}
