package ru.yandex.direct.grid.processing.service.autooverdraft.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.balance.container.PaymentMethodInfo;
import ru.yandex.direct.core.entity.balance.container.PersonPaymentMethodInfo;
import ru.yandex.direct.core.entity.client.model.ClientAutoOverdraftInfo;
import ru.yandex.direct.grid.processing.model.autooverdraft.GdPaymentMethodInfo;
import ru.yandex.direct.grid.processing.model.autooverdraft.GdPersonInfo;
import ru.yandex.direct.grid.processing.model.autooverdraft.GdPersonPaymentMethodInfo;
import ru.yandex.direct.grid.processing.model.client.GdClientAutoOverdraftInfo;
import ru.yandex.direct.grid.processing.model.client.GdClientInfo;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class AutoOverdraftDataConverter {

    private static GdPaymentMethodInfo toGdPaymentMethodInfo(PaymentMethodInfo paymentMethodInfo) {
        return new GdPaymentMethodInfo()
                .withCode(paymentMethodInfo.getCode())
                .withName(paymentMethodInfo.getName())
                .withLimit(paymentMethodInfo.getLimit())
                .withSelected(paymentMethodInfo.getSelected());
    }

    public static GdPersonPaymentMethodInfo toGdPersonPaymentMethod(PersonPaymentMethodInfo personPaymentMethodInfo) {
        return new GdPersonPaymentMethodInfo()
                .withPersonInfo(
                        new GdPersonInfo()
                                .withId(personPaymentMethodInfo.getPersonInfo().getId())
                                .withName(personPaymentMethodInfo.getPersonInfo().getName())
                                .withSelected(personPaymentMethodInfo.getPersonInfo().getSelected())
                )
                .withPaymentMethods(mapList(personPaymentMethodInfo.getPaymentMethods(),
                        AutoOverdraftDataConverter::toGdPaymentMethodInfo));
    }

    public static ClientAutoOverdraftInfo toClientAutoOverdraftInfo(GdClientInfo clientInfo) {
        GdClientAutoOverdraftInfo autoOverdraftInfo = clientInfo.getAutoOverdraftInfo();
        return new ClientAutoOverdraftInfo()
                .withClientId(clientInfo.getId())
                .withDebt(autoOverdraftInfo.getDebt())
                .withStatusBalanceBanned(autoOverdraftInfo.getStatusBalanceBanned())
                .withOverdraftLimit(autoOverdraftInfo.getOverdraftLimit())
                .withAutoOverdraftLimit(autoOverdraftInfo.getAutoOverdraftLimit());
    }
}
