package ru.yandex.direct.grid.processing.service.banner;

import java.util.Set;

import com.google.common.collect.ImmutableMap;
import one.util.streamex.EntryStream;

import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;

import static ru.yandex.direct.feature.FeatureName.CPM_AUDIO_GROUPS_EDIT_FOR_DNA;
import static ru.yandex.direct.feature.FeatureName.CPM_GEOPRODUCT_ENABLED;
import static ru.yandex.direct.feature.FeatureName.CPM_INDOOR_GROUPS_EDIT_FOR_DNA;
import static ru.yandex.direct.feature.FeatureName.CPM_OUTDOOR_GROUPS_EDIT_FOR_DNA;

public class AdTypeUtils {

    public static final ImmutableMap<GdAdType, FeatureName> EDITABLE_AD_FEATURE_BY_TYPE
            = ImmutableMap.<GdAdType, FeatureName>builder()
            .put(GdAdType.CPM_GEOPRODUCT, CPM_GEOPRODUCT_ENABLED)
            .put(GdAdType.CPM_INDOOR, CPM_INDOOR_GROUPS_EDIT_FOR_DNA)
            .put(GdAdType.CPM_OUTDOOR, CPM_OUTDOOR_GROUPS_EDIT_FOR_DNA)
            .put(GdAdType.CPM_AUDIO, CPM_AUDIO_GROUPS_EDIT_FOR_DNA)
            .build();

    public static Set<GdAdType> getEditableAdTypes(Set<String> enabledFeatures) {
        return EntryStream.of(EDITABLE_AD_FEATURE_BY_TYPE)
                .mapValues(FeatureName::getName)
                .filterValues(enabledFeatures::contains)
                .keys()
                .toSet();
    }
}
